/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.CachedMap;
import de.maxhenkel.pipez.corelib.helpers.AbstractStack;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.corelib.helpers.WrappedFluidStack;
import de.maxhenkel.pipez.corelib.helpers.WrappedItemStack;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.gui.ExtractScreen;
import de.maxhenkel.pipez.gui.WidgetBase;
import de.maxhenkel.pipez.utils.WrappedGasStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;

public class FilterList
extends WidgetBase {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("pipez", "textures/gui/container/extract.png");
    protected Supplier<List<Filter<?>>> filters;
    protected int offset;
    protected int selected;
    private ScreenBase.HoverArea[] hoverAreas;
    private ScreenBase.HoverArea[] itemHoverAreas;
    private ScreenBase.HoverArea[] blockHoverAreas;
    private int columnHeight;
    private int columnCount;
    private CachedMap<DirectionalPosition, Pair<BlockState, ItemStack>> filterPosCache;

    public FilterList(ExtractScreen screen, int posX, int posY, int xSize, int ySize, Supplier<List<Filter<?>>> filters) {
        super(screen, posX, posY, xSize, ySize);
        this.filters = filters;
        this.columnHeight = 22;
        this.columnCount = 3;
        this.selected = -1;
        this.hoverAreas = new ScreenBase.HoverArea[this.columnCount];
        this.itemHoverAreas = new ScreenBase.HoverArea[this.columnCount];
        this.blockHoverAreas = new ScreenBase.HoverArea[this.columnCount];
        for (int i = 0; i < this.hoverAreas.length; ++i) {
            this.hoverAreas[i] = new ScreenBase.HoverArea(0, i * this.columnHeight, xSize, this.columnHeight);
            this.itemHoverAreas[i] = new ScreenBase.HoverArea(3, 3 + i * this.columnHeight, 16, 16);
            this.blockHoverAreas[i] = new ScreenBase.HoverArea(xSize - 3 - 16 - 11, 3 + i * this.columnHeight, 16, 16);
        }
        this.filterPosCache = new CachedMap(1000L);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(PoseStack matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        List<Filter<?>> f = this.filters.get();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < f.size(); ++i) {
            Filter<?> filter = f.get(this.getOffset() + i);
            if (this.itemHoverAreas[i].isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                AbstractStack<?> stack = FilterList.getStack(filter);
                if (stack == null || stack.isEmpty()) continue;
                List<Component> tooltip = stack.getTooltip((Screen)this.screen);
                if (filter.isInvert()) {
                    tooltip.set(0, (Component)new TranslatableComponent("tooltip.pipez.filter.not").m_130940_(ChatFormatting.DARK_RED).m_130946_(" ").m_7220_(tooltip.get(0)));
                }
                if (filter.getTag() != null && !(filter.getTag() instanceof SingleElementTag)) {
                    tooltip.add((Component)new TranslatableComponent("tooltip.pipez.filter.accepts_tag", new Object[]{new TextComponent(filter.getTag().getName().toString()).m_130940_(ChatFormatting.BLUE)}).m_130940_(ChatFormatting.GRAY));
                }
                this.screen.renderTooltip(matrixStack, tooltip.stream().map(Component::m_7532_).collect(Collectors.toList()), mouseX - this.screen.getGuiLeft(), mouseY - this.screen.getGuiTop(), this.mc.f_91062_);
                continue;
            }
            if (!this.blockHoverAreas[i].isHovered(this.guiLeft, this.guiTop, mouseX, mouseY) || filter.getDestination() == null) continue;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            Pair<BlockState, ItemStack> destPair = this.getBlockAt(filter.getDestination());
            if (destPair.getKey() == null) {
                tooltip.add(ComponentUtils.m_130748_((Component)new TranslatableComponent("tooltip.pipez.filter.unknown_block")).m_130940_(ChatFormatting.DARK_RED));
            } else {
                tooltip.add(destPair.getKey().m_60734_().m_49954_().m_130940_(ChatFormatting.BLUE));
            }
            BlockPos pos = filter.getDestination().getPos();
            tooltip.add(new TranslatableComponent("tooltip.pipez.filter.destination_location", new Object[]{this.number(pos.m_123341_()), this.number(pos.m_123342_()), this.number(pos.m_123343_())}));
            tooltip.add(new TranslatableComponent("tooltip.pipez.filter.destination_distance", new Object[]{this.number(pos.m_123333_((Vec3i)this.getContainer().getPipe().m_58899_()))}));
            tooltip.add(new TranslatableComponent("tooltip.pipez.filter.destination_side", new Object[]{new TranslatableComponent("message.pipez.direction." + filter.getDestination().getDirection().m_122433_()).m_130940_(ChatFormatting.DARK_GREEN)}));
            this.screen.renderTooltip(matrixStack, tooltip.stream().map(Component::m_7532_).collect(Collectors.toList()), mouseX - this.screen.getGuiLeft(), mouseY - this.screen.getGuiTop(), this.mc.f_91062_);
        }
    }

    private MutableComponent number(int num) {
        return new TextComponent(String.valueOf(num)).m_130940_(ChatFormatting.DARK_GREEN);
    }

    @Nullable
    public static AbstractStack<?> getStack(Filter<?> filter) {
        WrappedGasStack gasStack;
        Object o = null;
        if (filter.getTag() != null) {
            o = FilterList.get(filter.getTag());
        }
        if (o instanceof Item) {
            ItemStack stack = new ItemStack((ItemLike)((Item)o));
            if (filter.getMetadata() != null) {
                stack.m_41751_(filter.getMetadata().m_6426_());
            }
            return new WrappedItemStack(stack);
        }
        if (o instanceof Fluid) {
            FluidStack stack = new FluidStack((Fluid)o, 1000);
            if (filter.getMetadata() != null) {
                stack.setTag(filter.getMetadata().m_6426_());
            }
            return new WrappedFluidStack(stack);
        }
        if (ModList.get().isLoaded("mekanism") && (gasStack = WrappedGasStack.dummyStack(o)) != null) {
            return gasStack;
        }
        return null;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        List<Filter<?>> f = this.filters.get();
        for (int i = this.getOffset(); i < f.size() && i < this.getOffset() + this.columnCount; ++i) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
            int pos = i - this.getOffset();
            int startY = this.guiTop + pos * this.columnHeight;
            Filter<?> filter = f.get(i);
            if (i == this.getSelected()) {
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)this.guiLeft, (int)startY, (float)0.0f, (float)218.0f, (int)125, (int)this.columnHeight, (int)256, (int)256);
            } else {
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)this.guiLeft, (int)startY, (float)0.0f, (float)196.0f, (int)125, (int)this.columnHeight, (int)256, (int)256);
            }
            AbstractStack<?> stack = FilterList.getStack(filter);
            if (stack != null && !stack.isEmpty()) {
                stack.render(matrixStack, this.guiLeft + 3, startY + 3);
                if (filter.getTag() != null) {
                    if (filter.getTag() instanceof SingleElementTag) {
                        this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 5, (Component)new TranslatableComponent("message.pipez.filter.item", new Object[]{new TranslatableComponent(stack.getDisplayName().getString()).m_130940_(ChatFormatting.BLUE)}).m_130940_(ChatFormatting.WHITE));
                    } else {
                        this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 5, (Component)new TranslatableComponent("message.pipez.filter.tag", new Object[]{new TextComponent(filter.getTag().getName().toString()).m_130940_(ChatFormatting.BLUE)}).m_130940_(ChatFormatting.WHITE));
                    }
                }
            } else {
                this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 5, (Component)new TranslatableComponent("message.pipez.filter.any_item").m_130940_(ChatFormatting.WHITE));
            }
            if (filter.getMetadata() != null && filter.getMetadata().m_128440_() > 0) {
                MutableComponent tags = new TranslatableComponent("message.pipez.filter.nbt.tag" + (filter.getMetadata().m_128440_() != 1 ? "s" : ""), new Object[]{filter.getMetadata().m_128440_()}).m_130940_(ChatFormatting.DARK_PURPLE);
                MutableComponent nbtStr = new TranslatableComponent("message.pipez.filter.nbt", new Object[]{tags}).m_130940_(ChatFormatting.WHITE);
                if (filter.isExactMetadata()) {
                    nbtStr.m_130946_(" ").m_7220_((Component)new TranslatableComponent("message.pipez.filter.nbt.exact"));
                }
                this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 10, (Component)nbtStr);
            }
            if (filter.isInvert()) {
                this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 15, (Component)new TranslatableComponent("message.pipez.filter.inverted").m_130940_(ChatFormatting.DARK_RED));
            }
            if (filter.getDestination() == null) continue;
            Pair<BlockState, ItemStack> dstPair = this.getBlockAt(filter.getDestination());
            this.mc.m_91291_().m_174229_((LivingEntity)this.mc.f_91074_, dstPair.getValue(), this.guiLeft + this.xSize - 3 - 16 - 11, startY + 3, 0);
            this.mc.m_91291_().m_115174_(this.mc.f_91062_, dstPair.getValue(), this.guiLeft + this.xSize - 3 - 16 - 11, startY + 3, String.valueOf(filter.getDestination().getDirection().name().charAt(0)));
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        if (f.size() > this.columnCount) {
            float h = 49.0f;
            float perc = (float)this.getOffset() / (float)(f.size() - this.columnCount);
            int posY = this.guiTop + (int)(h * perc);
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)(this.guiLeft + this.xSize - 10), (int)posY, (float)125.0f, (float)196.0f, (int)10, (int)17, (int)256, (int)256);
        } else {
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)(this.guiLeft + this.xSize - 10), (int)this.guiTop, (float)135.0f, (float)196.0f, (int)10, (int)17, (int)256, (int)256);
        }
    }

    private Pair<BlockState, ItemStack> getBlockAt(DirectionalPosition destination) {
        return this.filterPosCache.get(destination, () -> {
            ItemStack pickBlock;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42246_);
            BlockState state = null;
            if (this.mc.f_91073_.isAreaLoaded(destination.getPos(), 1) && (pickBlock = (state = this.mc.f_91073_.m_8055_(destination.getPos())).m_60734_().getCloneItemStack(state, (HitResult)new BlockHitResult(new Vec3((double)destination.getPos().m_123341_() + 0.5, (double)destination.getPos().m_123342_() + 0.5, (double)destination.getPos().m_123343_() + 0.5), destination.getDirection(), destination.getPos(), true), (BlockGetter)this.mc.f_91073_, destination.getPos(), (Player)this.mc.f_91074_)) != null && !pickBlock.m_41619_()) {
                stack = pickBlock;
            }
            return new Pair<Object, ItemStack>(state, stack);
        });
    }

    @Override
    public void tick() {
        super.tick();
        this.filterPosCache.clear();
    }

    public int getOffset() {
        List<Filter<?>> f = this.filters.get();
        if (f.size() <= this.columnCount) {
            this.offset = 0;
        } else if (this.offset > f.size() - this.columnCount) {
            this.offset = f.size() - this.columnCount;
        }
        return this.offset;
    }

    public int getSelected() {
        if (this.selected >= this.filters.get().size()) {
            this.selected = -1;
        }
        return this.selected;
    }

    private void drawStringSmall(PoseStack matrixStack, int x, int y, Component text) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
        this.mc.f_91062_.m_92889_(matrixStack, text, 0.0f, 0.0f, 0);
        matrixStack.m_85849_();
    }

    public static <T> T get(Tag<T> tag) {
        long time = Minecraft.m_91087_().f_91073_.m_46467_();
        List allElements = tag.getAll().stream().toList();
        return (T)allElements.get((int)(time / 20L % (long)allElements.size()));
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        List<Filter<?>> f = this.filters.get();
        if (f.size() > this.columnCount) {
            this.offset = delta < 0.0 ? Math.min(this.getOffset() + 1, f.size() - this.columnCount) : Math.max(this.getOffset() - 1, 0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<Filter<?>> f = this.filters.get();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < f.size(); ++i) {
            if (!this.hoverAreas[i].isHovered(this.guiLeft, this.guiTop, (int)mouseX, (int)mouseY)) continue;
            this.selected = this.getOffset() + i;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

